--this is a script for taking the lever in tutorial map into another place
require 'g_level'

local lever1 = {14080,-15,true} --x,y,is_closed
local lever2 = {14320,35,false} --x,y,is_closed
local door1 = {14580,100,true} --x,y,is_closed
local door2 = {14780,60,false} --x,y,is_closed
local door3 = {14980,70,true} --x,y,is_closed


local lever_sound = "data/music/Vipu.ogg"

--LEVER start
lua_init_texture("switch", "data/images/lvl_forest/switch.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)

lua:init_subtexture("switch","switch_1", 0.0, 0.0, 0.5, 1.0)
lua:init_subtexture("switch","switch_2", 0.0, 0.0, 0.5, 1.0)
lua:init_subtexture("switch","switch_3", 0.5, 0.0, 1.0, 1.0)
lua:init_subtexture("switch","switch_4", 0.5, 0.0, 1.0, 1.0)

lua:init_animation("lever_open", MODE_ONCE, DIRECTION_FORWARD)
local k = 0.075
lua:animation_add_frame("lever_open","switch_1",k)
lua:animation_add_frame("lever_open","switch_2",k)
lua:init_animation("lever_close", MODE_ONCE, DIRECTION_FORWARD)
lua:animation_add_frame("lever_close","switch_3",k)
lua:animation_add_frame("lever_close","switch_4",k)


local delay = 0.125
lua_init_texture_animation("door_disappear","data/images/lvl_forest/wall/", 11, MODE_ONCE, DIRECTION_FORWARD, delay, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua:animation_add_frame("door_disappear", "transparent", delay)

local delay = 0.125
lua_init_texture_animation("door_appear","data/images/lvl_forest/wall/", 11, MODE_ONCE, DIRECTION_REVERSE, delay, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)



--animated sprite creation
local scale = 0.5
local door_width = 512.0/2*scale
local door_height = 1024.0/2*scale

lua:create_sprite("door_open1", ST_ANIMATED,"door_disappear", door1[1],door1[2]) 
lua:sprite_shape("door_open1",ST_ANIMATED,door_width, door_height)
lua:create_sprite("door_close1", ST_ANIMATED,"door_appear", door1[1],door1[2])
lua:sprite_shape("door_close1",ST_ANIMATED,door_width, door_height)
lua:create_sprite("door_open2", ST_ANIMATED,"door_disappear", door2[1],door2[2]) 
lua:sprite_shape("door_open2",ST_ANIMATED,door_width, door_height)
lua:create_sprite("door_close2", ST_ANIMATED,"door_appear", door2[1],door2[2])
lua:sprite_shape("door_close2",ST_ANIMATED,door_width, door_height)
lua:create_sprite("door_open3", ST_ANIMATED,"door_disappear", door3[1],door3[2]) 
lua:sprite_shape("door_open3",ST_ANIMATED,door_width, door_height)
lua:create_sprite("door_close3", ST_ANIMATED,"door_appear", door3[1],door3[2])
lua:sprite_shape("door_close3",ST_ANIMATED,door_width, door_height)

local scale = 0.5
local lever_width = 128.0 * scale
local lever_height = 256.0 * scale
lua:create_sprite("lever_open1", ST_ANIMATED,"lever_open", lever1[1],lever1[2]) 
lua:sprite_shape("lever_open1",ST_ANIMATED,lever_width, lever_height)
lua:create_sprite("lever_close1", ST_ANIMATED,"lever_close", lever1[1],lever1[2]) 
lua:sprite_shape("lever_close1",ST_ANIMATED,lever_width, lever_height)
lua:create_sprite("lever_open2", ST_ANIMATED,"lever_open", lever2[1],lever2[2]) 
lua:sprite_shape("lever_open2",ST_ANIMATED,lever_width, lever_height)
lua:create_sprite("lever_close2", ST_ANIMATED,"lever_close", lever2[1],lever2[2]) 
lua:sprite_shape("lever_close2",ST_ANIMATED,lever_width, lever_height)

--collider creation
local width = 60
local height = 500
lua:create_shape("rectangle1",PSC_RECTANGLE,width,height) -- name, type, width, height
lua:create_collider(1111,"rectangle1",door1[1],door1[2]) --id, shape, x ,y
lua:create_shape("rectangle2",PSC_RECTANGLE,width,height) -- name, type, width, height
lua:create_collider(1112,"rectangle2",door2[1],door2[2]) --id, shape, x ,y
lua:create_shape("rectangle3",PSC_RECTANGLE,width,height) -- name, type, width, height
lua:create_collider(1113,"rectangle3",door3[1],door3[2]) --id, shape, x ,y

--sound creation
lua:create_sound("lever_sound_open1",lever_sound, 500.0, lever1[1],lever1[2])  --name, music_name, radius, x,y
lua:create_sound("lever_sound_close1",lever_sound, 500.0, lever1[1],lever1[2])  --name, music_name, radius, x,y
lua:create_sound("lever_sound_open2",lever_sound, 500.0, lever2[1],lever2[2])  --name, music_name, radius, x,y
lua:create_sound("lever_sound_close2",lever_sound, 500.0, lever2[1],lever2[2])  --name, music_name, radius, x,y
lua:create_sound("door_sound_open1",lever_sound, 500.0, door1[1],door1[2])  --name, music_name, radius, x,y
lua:create_sound("door_sound_close1",lever_sound, 500.0, door1[1],door1[2])  --name, music_name, radius, x,y
lua:create_sound("door_sound_open2",lever_sound, 500.0, door2[1],door2[2])  --name, music_name, radius, x,y
lua:create_sound("door_sound_close2",lever_sound, 500.0, door2[1],door2[2])  --name, music_name, radius, x,y
lua:create_sound("door_sound_open3",lever_sound, 500.0, door3[1],door3[2])  --name, music_name, radius, x,y
lua:create_sound("door_sound_close3",lever_sound, 500.0, door3[1],door3[2])  --name, music_name, radius, x,y

--lever door creation
lua:create_door("door1","door_open1","door_close1","door_sound_open1","door_sound_close1",1111,door1[3]) --name, open animated sprite, close animated sprite, open_sound, close_sound,collider_id, is_closed
local door1_id = g_level.upload("door1",4)
lua:create_door("door2","door_open2","door_close2","door_sound_open2","door_sound_close2",1112,door1[3]) --name, open animated sprite, close animated sprite, open_sound, close_sound,collider_id, is_closed
local door2_id = g_level.upload("door2",4)
lua:create_door("door3","door_open3","door_close3","door_sound_open3","door_sound_close3",1113,door1[3]) --name, open animated sprite, close animated sprite, open_sound, close_sound,collider_id, is_closed
local door3_id = g_level.upload("door3",4)
lua:create_lever("lever1","lever_open1","lever_close1","lever_sound_open1","lever_sound_close1",lever1[3]) --name , open animated sprite, close animated sprite, open_sound, close_sound, is_closed
local lever1_id = g_level.upload("lever1",4)
lua:create_lever("lever2","lever_open2","lever_close2","lever_sound_open2","lever_sound_close2",lever2[3]) --name , open animated sprite, close animated sprite, open_sound, close_sound, is_closed
local lever2_id = g_level.upload("lever2",4)

--add trigger
switch_adv("data/scripts/test/srt_use_lever.lua",lever1[1],lever1[2],50,lever1_id) --script ,x,y, radius, id
switch_adv("data/scripts/test/srt_use_lever.lua",lever2[1],lever2[2],50,lever2_id) --script ,x,y, radius, id

--signals
--lever1 open
lua:add_lever_door_signal(lever1_id,true,door1_id,false) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever1_id,true,door2_id,true) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever1_id,true,door3_id,false) --lever_id, lever_is_opened, door_id, door_is_opened
--lever1 close
lua:add_lever_door_signal(lever1_id,false,door1_id,false) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever1_id,false,door2_id,false) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever1_id,false,door3_id,true) --lever_id, lever_is_opened, door_id, door_is_opened
--lever2 open
lua:add_lever_door_signal(lever2_id,true,door1_id,true) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever2_id,true,door2_id,true) --lever_id, lever_is_opened, door_id, door_is_opened
--lever2 close
lua:add_lever_door_signal(lever2_id,false,door1_id,true) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever2_id,false,door2_id,false) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever2_id,false,door3_id,false) --lever_id, lever_is_opened, door_id, door_is_opened

--LEVER stop